/*
 *  link editor
 */

#include <stdio.h>
#include <signal.h>
#include <a.out.h>
#include <sys/types.h>
#include <sys/stat.h>

#define WDLEN    4
#define SEGSIZE  0xffff   /* 64K bytes per segment */
#define HALFWD   0177777  /* 16 bits/halfword */
#define BYTE     0377     /* 8 bits/byte */

#define ARCMAGIC 0177545


#define N_DENTR 0300

#define COMM    05        /* internal use only */

#define RELFLG  01
#define NROUT   256
#define NSYM    1009
#define NSYMPR  1000

#define RONLY   0400

char    premeof[] = "Premature EOF.";
char    goodnm[] = "__.SYMDEF";

/* table of contents stuff */
#define TABSZ   700
struct tab
{       char cname[8];
	int cloc;
} tab[TABSZ];
int tnum;

/* input management */
struct  page {
	int     nuser;
	int     bno;
	int     nibuf;
	int     buff[1024];
} page[2];

struct  {
	int     nuser;
	int     bno;
} fpage;

struct  stream {
	int     *ptr;
	int     bno;
	int     nibuf;
	int     size;
	struct  page *pno;
};

struct  stream text;
struct  stream rel;

struct  archdr {
	char    aname[14];
	int     atime;
	short   auid, agid;
	short   amode;
	int     asize;
} archdr;

struct  exec filhdr;

struct  reloc  relocst;

int liblist[NROUT];    /* one entry for each archive member referenced */
int *libp = liblist;

struct local {        
	int locindex;              /* index to symbol in file */
	struct nlist *locsymbol;   /* ptr to symbol table */
};
struct  local  local[NSYMPR];

struct  nlist  cursym;             /* current symbol */
struct  nlist  symtab[NSYM];       /* actual symbols */
struct  nlist  **symhash[NSYM];    /* ptr to hash table entry */
struct  nlist  *lastsym;           /* last symbol entered */
int     symindex;                  /* next available symbol table entry */
struct  nlist  *hshtab[NSYM+2];    /* hash table for symbols */

/* internal symbols */
struct  nlist  *p_etext;
struct  nlist  *p_edata;
struct  nlist  *p_end;
struct  nlist  *entrypt;

/* flags */
int     xflag;         /* discard local symbols */
int     Xxflag;        /* discard locals starting with '$' */
int     rflag;         /* preserve relocation bits, don't define common */
int     arflag;        /* original copy of rflag */
int     sflag;         /* discard all symbols */
int     nflag;         /* pure procedure */
int     dflag;         /* define common even with rflag */

int     ofilfnd;
char    *ofilename   =  "l.out";
FILE    *infil;
char    *filname;

/* cumulative sizes set in pass 1 */
int     tsize;
int     dsize;
int     bsize;
int     rsize;
int     ssize;

/* used after pass 1 */
int     nsym;
int     torigin;
int     dorigin;
int     borigin;

/* symbol relocation; both passes */
int     ctrel;
int     cdrel;
int     cbrel;

int     errlev;
int     delarg = 4;
char    tfname[] = "/tmp/lxyyyyy";

FILE    *toutb;
FILE    *doutb;
FILE    *troutb;
FILE    *droutb;
FILE    *soutb;

int     tcurpos;
FILE    *tdoutp;
FILE    *tdroutp;

FILE    *tcreat();  
struct  nlist  **lookup();
struct  nlist  **slookup();
struct  nlist  *lookloc();  
char    *mkfilnm();

main(argc, argv)
char **argv;
{
	extern int delexit();
	register c;
	register char *ap, **p;

	if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
		signal(SIGHUP, delexit);
	if (signal(SIGINTR, SIG_IGN) != SIG_IGN)
		signal(SIGINTR, delexit);
	if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
		signal(SIGQUIT, delexit);
	if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
		signal(SIGTERM, delexit);
	if (signal(SIGNOSPC, SIG_IGN) != SIG_IGN)
		signal(SIGNOSPC, delexit);
	if (argc == 1)
		exit(4);
	p = argv + 1;

	/* scan files once to find symdefs */
	for (c = 1; c<argc; c++) {
		filname = '\0';
		ap = *p++;
		if (*ap == '-') switch (ap[1]) {

		case 'o':
			if (++c >= argc)
				error(2, "Bad output file");
			ofilename = *p++;
			ofilfnd++;
			continue;

		case 'u':
		case 'e':
			if (++c >= argc)
				error(2, "Bad 'use' or 'entry'");
                        enter(slookup(*p++));
			if (ap[1]=='e')
				entrypt = lastsym;
			continue;

		case 'l':
			break;

		case 'x':
			xflag++;
			continue;

		case 'X':
			Xxflag++;
			continue;

		case 'r':
			rflag++;
			arflag++;
			continue;

		case 's':
			sflag++;
			xflag++;
			continue;

		case 'n':
			nflag++;
			continue;

		case 'd':
			dflag++;
			continue;
		}
		load1arg(ap);
	}
	filname = '\0';
	middle();
	setupout();
	p = argv+1;
	libp = liblist;
	for (c=1; c<argc; c++) {
		ap = *p++;
		if (*ap == '-') switch (ap[1]) {

		case 'u':
		case 'e':
		case 'o':
			++c;
			++p;
		default:
			continue;

		case 'l':
			break;
		}
		load2arg(ap);
	}
	finishout();
}


/* scan file to find defined symbols */
load1arg(acp)
char *acp;
{
	register char *cp;
        int nloc;

	cp = acp;
	switch ( getfile(cp)) {
	case 0:
		load1(0, 0);
		break;

	/* regular archive */
	case 1:
                nloc = 1;
                while ( step(nloc))
                        nloc += (archdr.asize + sizeof(archdr)) / WDLEN;
		break;

	/* table of contents */
	case 2:
		tnum = archdr.asize / sizeof(struct tab);
		if (tnum >= TABSZ) {
			error(2, "Fast load buffer too small");
		}
                fseek(infil, (sizeof(filhdr.a_magic)+sizeof(archdr)), 0);
                fread((char *)tab, sizeof(struct tab), tnum, infil);
		while (ldrand());
		*libp = -1;
		libp++;
		break;

	/* out of date table of contents */
	case 3:
                error(0, "Out of date (warning)");
                for(nloc = 1 + (archdr.asize + sizeof(archdr)) / WDLEN;
			step(nloc);
                        nloc += (archdr.asize + sizeof(archdr)) / WDLEN);
		break;
	}
	fclose(infil);
}

step(nloc)
{
        dseek(&text, nloc, sizeof archdr);
        if (text.size <= 0) {
                *libp = -1;
                libp++;
                return(0);
        }
        mget((int *)&archdr, sizeof archdr);
        if (load1(1, nloc + (sizeof archdr) / WDLEN)) {
                *libp = nloc;
                libp++;
        }

	return(1);
}

ldrand()
{
	int i;
	struct nlist *sp, **pp;
	int *oldp = libp;

	for(i = 0; i<tnum; i++) {
		if ((pp = slookup(tab[i].cname)) == 0)
			continue;
		sp = *pp;
		if (sp->n_type != N_EXT+N_UNDF)
			continue;
		step(tab[i].cloc / WDLEN);
	}
	return(oldp != libp);
}

/* single file or archive member */
load1(libflg, loc)
{
	register struct nlist *sp;
	int savindex;  
	int ndef, nloc;

	readhdr(loc);
	ctrel = tsize;
	cdrel += dsize;
	cbrel += bsize;
	ndef = 0;
	nloc = sizeof cursym;
	savindex = symindex;  
	if ((filhdr.a_flag&RELFLG)==1) {
		error(1, "No relocation bits");
		return(0);
	}
	loc += ((sizeof filhdr + filhdr.a_text + filhdr.a_data +
		filhdr.a_reloc) / WDLEN);
        dseek(&text, loc, filhdr.a_syms);
	while (text.size > 0) {
		mget((int *)&cursym, sizeof cursym);
		if ((cursym.n_type&N_EXT)==0) {
			if (Xxflag==0 || cursym.n_name[0]!='$')
				nloc += sizeof cursym;
			continue;
		}
		symreloc();
		if (enter(lookup()))
			continue;
		if (((sp = lastsym)->n_type != N_EXT+N_UNDF) && (sp->n_type != N_UNDF+N_DENTR))
			continue;
		if ((cursym.n_type == N_EXT+N_UNDF) || (cursym.n_type == N_UNDF+N_DENTR)) {
			if (cursym.n_value > sp->n_value)
				sp->n_value = cursym.n_value;
			continue;
		}
		if (sp->n_value != 0 && (cursym.n_type == N_EXT+N_TEXT || cursym.n_type == N_TEXT+N_DENTR))
			continue;
		ndef++;
		sp->n_type = cursym.n_type;
		sp->n_value = cursym.n_value;
	}
	if (libflg==0 || ndef) {
		tsize += filhdr.a_text;
		dsize += filhdr.a_data;
		bsize += filhdr.a_bss;
		rsize += filhdr.a_reloc;
		ssize += nloc;
		return(1);
	}
	/*
	 * No symbols defined by this library member.
	 * Rip out the hash table entries and reset the symbol table.
	 */
	while (symindex > savindex)
		*symhash[--symindex] = 0;
	return(0);
}

middle()
{
	register struct nlist *sp, *symp;
	register t, csize;
	int nund, corigin;
	int ndbl, nfull, nhalf, nbyte, cdbl, cfull, chalf, cbyte;
	ndbl = nfull = nhalf = nbyte = cdbl = cfull = chalf = cbyte = 0;

	p_etext = *slookup("etext");
	p_edata = *slookup("edata");
	p_end = *slookup("end");
	/*
	 * If there are any undefined symbols, save the relocation bits.
	 */
	symp = &symtab[symindex];
	if (rflag==0) for (sp=symtab; sp<symp; sp++)
		if ((sp->n_type==N_EXT+N_UNDF || sp->n_type==N_UNDF+N_DENTR) && sp->n_value==0
		 && sp!=p_end && sp!=p_edata && sp!=p_etext) {
			rflag++;
			dflag = 0;
			nflag = 0;
			sflag = 0;
			break;
		}
	/*
	 * Assign common locations.
	 */
	csize = 0;
	if (dflag || rflag==0) {
		for(sp = symtab; sp < symp; sp++)
			if (sp->n_type == N_EXT + N_UNDF &&
				(t = sp->n_value) != 0){
				sp->n_type = N_EXT + COMM;
				if (t & 01)
					nbyte += t;
				else
					if (t & 02)
						nhalf += t;
					else
						if (t & 04)
							nfull += t;
						else
							ndbl += t;
			}
		for (sp = symtab; sp < symp; sp++)
			if (sp->n_type == N_EXT + COMM)
				if ((t = sp->n_value) & 01){
					sp->n_value = ndbl + nfull + nhalf+cbyte;
					cbyte += t;
				}else
					if (t & 02){
						sp->n_value = ndbl + nfull+chalf;
						chalf += t;
					}else
						if (t & 04){
							sp->n_value =
							   ndbl+cfull;
							cfull += t;
						}else{
							sp->n_value =
							   cdbl;
							cdbl += t;
						}
		csize = (ndbl + nfull + nhalf + nbyte + 07) & ~07;
		if (p_etext && p_etext->n_value == 0 && p_etext->n_type==N_EXT+N_UNDF) {
			p_etext->n_type = N_EXT+N_TEXT;
			p_etext->n_value = tsize;
		}
		if (p_edata && p_edata->n_value == 0 && p_edata->n_type==N_EXT+N_UNDF) {
			p_edata->n_type = N_EXT+N_DATA;
			p_edata->n_value = dsize;
		}
		if (p_end && p_end->n_value == 0 && p_end->n_type==N_EXT+N_UNDF) {
			p_end->n_type = N_EXT+N_BSS;
			p_end->n_value = bsize;
		}
	}
	/*
	 * Now set symbols to their final value
	 */
	dorigin = tsize;
	if (nflag)
		dorigin = (tsize+SEGSIZE) & ~SEGSIZE;
	corigin = dorigin + dsize;
	borigin = corigin + csize;
	nund = 0;
	for (sp=symtab; sp<symp; sp++) switch (sp->n_type) {
	case N_UNDF+N_DENTR:
	case N_EXT+N_UNDF:
		if (arflag==0 && sp->n_value==0) {
			errlev |= 01;
			if (nund==0)
				printf("Undefined:\n");
			nund++;
			printf("%.8s\n", sp->n_name);
		}
		continue;

	case N_EXT+N_ABS:
	default:
		continue;

	case N_TEXT+N_DENTR:
	case N_EXT+N_TEXT:
		sp->n_value += torigin;
		continue;

	case N_EXT+N_DATA:
		sp->n_value += dorigin;
		continue;

	case N_EXT+N_BSS:
		sp->n_value += borigin;
		continue;

	case N_EXT+COMM:
		sp->n_type = N_EXT+N_BSS;
		sp->n_value += corigin;
		continue;
	}
	if (sflag || xflag)
		ssize = 0;
	bsize += csize;
	nsym = ssize / (sizeof cursym);
}

setupout()
{
	register char *p;
	register pid;
	struct nlist *ep;

	if ((toutb = fopen(ofilename, "w")) == NULL)
		error(2, "Can't create output");
	pid = getpid();
	for (p = &tfname[12]; p > &tfname[7];) {
		*--p = (pid&07) + '0';
		pid >>= 3;
	}
	doutb = tcreat('a');
	if (sflag==0 || xflag==0)
		soutb = tcreat('b');
	if (rflag) {
		troutb = tcreat('c');
		droutb = tcreat('d');
	}
	filhdr.a_magic = A_MAGIC1;
	if (nflag)
		filhdr.a_magic = A_MAGIC2;
	filhdr.a_text = tsize;
	filhdr.a_data = dsize;
	filhdr.a_bss = bsize;
	filhdr.a_reloc = rflag? rsize: 0;
	filhdr.a_syms = sflag? 0: (ssize + (sizeof cursym)*symindex);
	filhdr.a_entry = 0;
	if (ep = entrypt) {
		if (ep->n_type!=N_EXT+N_TEXT && ep->n_type!=N_TEXT+N_DENTR)
			error(1, "Entry point not in text");
		else
			filhdr.a_entry = ep->n_value | 01;
	}
	filhdr.a_flag = (rflag==0);
	mput(toutb, (int *)&filhdr, sizeof filhdr);
	return;
}

FILE *
tcreat(letter)
{
	int mode; 
	FILE *tfp; 

	tfname[6] = letter;
	mode = umask(0222);
	if ((tfp = fopen(tfname, "w")) == NULL)
		error(2, "Can't create temp");
	umask(mode);
	return(tfp);  
}

load2arg(acp)
char *acp;
{
	register char *cp;
	register *lp;

	cp = acp;
	if (getfile(cp) == 0) {
		while (*cp)
			cp++;
		while (cp >= acp && *--cp != '/');
		mkfsym(++cp);
		load2(0);
	} else {       /* scan archive members referenced */
                for (lp = libp; *lp != -1; lp++) {
                        dseek(&text, *lp, sizeof archdr);
                        mget((int *)&archdr, sizeof archdr);
                        mkfsym(archdr.aname);
                        load2(*lp + (sizeof archdr) / WDLEN);
                }
                libp = ++lp;
	} 
	fclose(infil);
}

load2(loc)
{
	register struct nlist *sp;
	register symno;
	struct local *lp; 

	readhdr(loc);
	ctrel = torigin;
	cdrel += dorigin;
	cbrel += borigin;
	/*
	 * Reread the symbol table, recording the numbering
	 * of symbols for fixing external references.
	 */
	lp = local;
	symno = -1;
	loc += (sizeof filhdr) / WDLEN;
        dseek(&text, loc + (filhdr.a_text + filhdr.a_data +
	      filhdr.a_reloc) / WDLEN, filhdr.a_syms);
	while (text.size > 0) {
		symno++;
		mget((int *)&cursym, sizeof cursym);
		symreloc();
		if ((cursym.n_type&N_EXT) == 0) {
			if (!sflag && !xflag && (!Xxflag ||
				    cursym.n_name[0] != '$'))
				mput(soutb, (int *)&cursym, sizeof cursym);
			continue;
		}
		if ((sp = *lookup()) == 0)
			error(2, "Internal error: symbol not found");
		if (cursym.n_type == N_EXT+N_UNDF) {
			if (lp >= &local[NSYMPR])
				error(2, "Local symbol overflow");
			lp->locindex = symno;
			lp++->locsymbol = sp;
			continue;
		}
		if (cursym.n_type!=sp->n_type || cursym.n_value!=sp->n_value) {
			printf("%.8s: ", cursym.n_name);
			error(1, "Multiply defined");
		}
	}
        dseek(&text, loc, filhdr.a_text + filhdr.a_data);
        dseek(&rel, loc + (filhdr.a_text + filhdr.a_data) / WDLEN,
		filhdr.a_reloc);
	load2td(lp);
	torigin += filhdr.a_text;
	dorigin += filhdr.a_data;
	borigin += filhdr.a_bss;
}

load2td(lp)
struct local *lp;
{
	int nreloc, t;
	int word; 
        char *msg;
	struct nlist *sp;

	nreloc = filhdr.a_reloc / sizeof relocst;
	tinit();
	while (nreloc--){
		relocst.r_addr = get (&rel);
		word = get (&rel);
		relocst.r_len = word >> 24;
		relocst.r_type = (word >> 16) & BYTE;
		relocst.r_symno = word;

		t = tget();
                switch (relocst.r_type) {
			case N_TEXT:
				t += ctrel;
				break;
			case N_DATA:
				t += cdrel;
				break;
			case N_BSS:
				t += cbrel;
				break;
			case N_EXT:
				sp = lookloc (lp, relocst.r_symno);
				if (sp->n_type == N_EXT + N_UNDF)
                                        relocst.r_symno =
					      (nsym + (sp - symtab));
				else{
					t += sp->n_value;
				        relocst.r_symno = 0;
					if (sp->n_type & (~N_EXT & N_DENTR))
						relocst.r_type =
						   sp->n_type - N_DENTR;
					else
	                                        relocst.r_type =
					           sp->n_type - N_EXT;
				}
				break;
                        case N_DENTR:
                                sp = lookloc(lp, relocst.r_symno);
                                if (sp->n_type == N_EXT+N_TEXT ||
                                    sp->n_type == N_TEXT+N_DENTR) {
                                        sprintf(msg, "Call '%s' directly - don't use 'call' system call", sp->n_name);
                                        error(2, msg);
                                } else if (sp->n_type == N_UNDF+N_DENTR)
                                        relocst.r_symno =
                                           nsym + (sp - symtab);
                                else {
                                        t += sp->n_value;
                                        relocst.r_symno = 0;
                                        relocst.r_type =
                                           sp->n_type - N_DENTR;
		                }
                                break;
		}
		if (relocst.r_addr < filhdr.a_text)
			relocst.r_addr += ctrel;
		else
			relocst.r_addr += cdrel;
		tput(t);
		if (rflag){
			putw(relocst.r_addr, tdroutp);
			putc(relocst.r_len, tdroutp);
			putc(relocst.r_type, tdroutp);
			puthw(relocst.r_symno, tdroutp);
		}
	}
	tflush();
}

finishout()
{
	register *p;

	copy(doutb, 'a');
	if (rflag) {
		copy(troutb, 'c');
		copy(droutb, 'd');
	}
	if (sflag==0) {
		if (xflag==0)
			copy(soutb, 'b');
		for (p=(int *)symtab; p < (int *)&symtab[symindex];)
			putw(*p++, toutb);
	}
	fclose(toutb);
	if (!ofilfnd) {
		unlink("a.out");
		link("l.out", "a.out");
		ofilename = "a.out";
	}
	delarg = errlev;
	delexit();
}

delexit()
{
	register c;

	unlink("l.out");
	for (c = 'a'; c <= 'd'; c++) {
		tfname[6] = c;
		unlink(tfname);
	}
	if (delarg==0)
		chmod(ofilename, 0777 & ~umask(0));
	exit(delarg);
}

copy(buf, c)
FILE *buf;
{
	register w;
	FILE *f;

	fclose(buf);
	tfname[6] = c;
	f = fopen(tfname, "r");
	w = getw(f);
	while (!feof(f)) {
		putw(w, toutb);
	        w = getw(f);
	}
	fclose(f);
	}

mkfsym(s)
char *s;
{

	if (sflag || xflag)
		return;
	cp8c(s, cursym.n_name);
	cursym.n_type = 037;
	cursym.n_value = torigin;
	mput(soutb, (int *)&cursym, sizeof cursym);
}

mget(aloc, an)
int *aloc;
{
	register *loc, n;
	register *p;

	n = an / WDLEN;
	loc = aloc;
	if ((text.nibuf -= n) >= 0) {
		if ((text.size -= n) > 0) {
			p = text.ptr;
			do
				*loc++ = *p++;
			while (--n);
			text.ptr = p;
			return;
		} else
			text.size += n;
	}
	text.nibuf += n;
	do {
		*loc++ = get(&text);
	} while (--n);
}

mput(buf, aloc, an)
FILE *buf;  
int *aloc;
{
	register *loc;
	register n;

	loc = aloc;
        n = an / WDLEN;
	do {
		putw(*loc++, buf);
	} while (--n);
}

dseek(asp, aloc, s)
struct stream *asp;  
{
	register struct stream *sp;
	register struct page *p;
	register b, o;
	int n;

        b = aloc >> 10; /* 2**10 = 1024 = no. words per block */
        o = aloc & 01777;
	sp = asp;
	--sp->pno->nuser;
	if ((p = &page[0])->bno!=b && (p = &page[1])->bno!=b)
		if (p->nuser==0 || (p = &page[0])->nuser==0) {
			if (page[0].nuser==0 && page[1].nuser==0)
				if (page[0].bno < page[1].bno)
					p = &page[0];
			p->bno = b;
			fseek(infil, b*4096, 0);
			n = fread((char *)p->buff, sizeof (int), BUFSIZ / sizeof (int), infil);
			p->nibuf = n;
		} else
			error(2, "No pages");
	++p->nuser;
	sp->bno = b;
	sp->pno = p;
	sp->ptr = p->buff + o;
	if (s != -1)
		sp->size = s / WDLEN;
	if ((sp->nibuf = p->nibuf-o) <= 0)
		sp->size = 0;
}

get(asp)
struct stream *asp;
{
	register struct stream *sp;

	sp = asp;
	if (--sp->nibuf < 0) {
                dseek(sp, (sp->bno+1) * BUFSIZ / WDLEN, -1);
		--sp->nibuf;
	}
	if (--sp->size <= 0) {
		if (sp->size < 0)
			error(2, premeof);
		++fpage.nuser;
		--sp->pno->nuser;
		sp->pno = (struct page *)&fpage;
	}
	return(*sp->ptr++);
}

getfile(acp)
char *acp;
{
	char *cp;
	struct stat x;   

	cp = acp;
	infil = NULL;
	archdr.aname[0] = '\0';
	filname = cp;
	if (cp[0]=='-' && cp[1]=='l') {
		if(cp[2] == '\0')
			cp = "-la";
		filname = mkfilnm(cp);
		if ((infil = fopen(filname+4, "r")) != NULL) {
			filname += 4;
		}
	}
	if (infil == NULL && (infil = fopen(filname, "r")) == NULL)
		error(2, "Can't open");
	page[0].bno = page[1].bno = -1;
	page[0].nuser = page[1].nuser = 0;
	text.pno = rel.pno = (struct page *)&fpage;
	fpage.nuser = 2;
        dseek(&text, 0, WDLEN);
	if (text.size <= 0)
		error(2, premeof);
	if((get(&text)) != ARCMAGIC)
		return(0);                /* regular file */
	dseek(&text, 1, sizeof archdr);
	if(text.size <= 0)
		return(1);                /* regular archive */
	mget((int *)&archdr, sizeof archdr);
	if(strncmp(archdr.aname, goodnm, 14) != 0)
		return(1);                /* regular archive */
	else {
		fstat(fileno(infil), &x);
		if(x.st_mtime > archdr.atime)
			return(3);        /* out of date table of contents */
		else return(2);           /* table of contents */
	}
}

char *
mkfilnm(cp)
char *cp;
{
	register c;

	filname = "/usr/lib/libxxxxxxxxxxxxxxx";
	for(c=0; cp[c+2]; c++)
		filname[c+12] = cp[c+2];
	filname[c+12] = '.';
	filname[c+13] = 'a';
	filname[c+14] = '\0';
	return(filname);
}

struct nlist **
lookup()
{
	int i;
	register struct nlist **hp;
	register char *cp, *cp1;

	i = 0;
	for (cp=cursym.n_name; cp < &cursym.n_name[8];)
		i = (i<<1) + *cp++;
	for (hp = &hshtab[(i&077777)%NSYM+2]; *hp!=0;) {
		cp1 = (*hp)->n_name;
		for (cp=cursym.n_name; cp < &cursym.n_name[8];)
			if (*cp++ != *cp1++)
				goto no;
		break;
	    no:
		if (++hp >= &hshtab[NSYM+2])
			hp = hshtab;
	}
	return(hp);
}

struct nlist **
slookup(s)
char *s;
{
	cp8c(s, cursym.n_name);
	cursym.n_type = N_EXT+N_UNDF;
	cursym.n_value = 0;
	return(lookup());
}

enter(hp)
struct nlist **hp;
{
	register struct nlist *sp;

	if (*hp==0) {
		if (symindex>=NSYM)
			error(2, "Symbol table overflow");
		symhash[symindex] = hp;
		*hp = lastsym = sp = &symtab[symindex++];
		cp8c(cursym.n_name, sp->n_name);
		sp->n_type = cursym.n_type;
		sp->n_value = cursym.n_value;
		return(1);
	} else {
		lastsym = *hp;
		return(0);
	}
}

symreloc()
{
	switch (cursym.n_type) {

	case N_TEXT:
	case N_TEXT+N_DENTR:
	case N_EXT+N_TEXT:
		cursym.n_value += ctrel;
		return;

	case N_DATA:
	case N_EXT+N_DATA:
		cursym.n_value += cdrel;
		return;

	case N_BSS:
	case N_EXT+N_BSS:
		cursym.n_value += cbrel;
		return;

	case N_UNDF+N_DENTR:
	case N_EXT+N_UNDF:
		return;
	}
	if (cursym.n_type & N_DENTR)
		return;
	if (cursym.n_type & N_EXT)
		cursym.n_type = N_EXT+N_ABS;
}

error(n, s)
char *s;
{
	if (errlev == 0)  
		printf("ld: ");  
	if (filname) {
		printf("%s", filname);
		if (archdr.aname[0])
			printf("(%.14s)", archdr.aname);
		printf(": ");
	}
	printf("%s\n", s);
	if (n > 1)
		delexit();
	errlev = n;
}

struct nlist *
lookloc(alp, r)
struct local *alp;  
{
	register struct local *clp, *lp;
	register sn;

	lp = alp;
	sn = r;
	for (clp=local; clp<lp; clp++)
		if (clp->locindex == sn)
			return(clp->locsymbol);
	error(2, "Local symbol botch");
}

readhdr(loc)
{
        dseek(&text, loc, sizeof filhdr);
	mget((int *)&filhdr, sizeof filhdr);
	if (filhdr.a_magic != A_MAGIC1)
		error(2, "Bad format");
	cdrel = -filhdr.a_text;
	cbrel = cdrel - filhdr.a_data;
}

cp8c(from, to)
char *from, *to;
{
	register char *f, *t, *te;

	f = from;
	t = to;
	te = t+8;
	while ((*t++ = *f++) && t<te);
	while (t<te)
		*t++ = 0;
}

tinit()
{
	tcurpos = 0;
	tdoutp = toutb;
	tdroutp = troutb;
}

tget() /* return the adcon pointed to by relocst */
{
	char c;
        int t, len;
	static int tbyteno, tword;

	while (relocst.r_addr > tcurpos){
		if (tbyteno == 0) {
			tword = get (&text);
			tbyteno = 4;
		}
		c = (tword >> (--tbyteno * 8)) & BYTE;
		if (tcurpos++ == filhdr.a_text) {
			tdoutp = doutb;
			tdroutp = droutb;
		}
		putc(c, tdoutp);
	}
	if (tcurpos == filhdr.a_text) {
		tdoutp = doutb;
		tdroutp = droutb;
	}
	t = 0;
        len = relocst.r_len;
        tcurpos += len;
        while (len--) {
		if (!tbyteno) {
			tword = get (&text);
			tbyteno = 4;
		}
		t = (t << 8) + ((tword >> (--tbyteno * 8)) & BYTE);
	}
	return (t);
}

tput(t)
{
	int len;

        len = relocst.r_len;
	if (len > 0)
                switch (len) {
                case 4:
                        putw (t, tdoutp);
                        break;
                case 2:
                        puthw (t, tdoutp);
                        break;
                case 1:
                        putc (t, tdoutp);
                        break;
                }
}

tflush() /* kludge to get tget to process the rest of the text and data */
{
	relocst.r_addr = filhdr.a_text + filhdr.a_data;
        relocst.r_len = 0;
	tget();
}


