/*
 * Find name(s) for given information.
 *
 * findarch [-u userid][-n name][-d date][-i info]
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <time.h>
#include <pwd.h>

#define MARK 07
#define NEWLINE '\n'
#define EOS     '\0'
#define MAXLINE 512
#define PUBREAD 04

char today[] = "/usr/spool/arch/.today";
char inform[4096];
char *iam;
char *userid;
char *date;
char *name;
char *info;
extern  char    *cmdname;

int  ndate;

/*  ARGSUSED  */
main(argc, argv)
int argc;
char *argv[];
{
	struct passwd *getpwuid();
	struct passwd *pw;
	char    *getlogin();
	FILE *fptoday;
	int  bell;

	if ((iam = getlogin()) == NULL) {
		pw = getpwuid(getuid());
                iam = pw->pw_name;
	}
	while(**++argv == '-') {
		switch(*++*argv) {
		case 'u':
			userid = *++argv;
			break;
		case 'n':
			name = *++argv;
			break;
		case 'd':
			date = *++argv;
			if((ndate = timec(date, -1)) < 0) {
				fprintf(stderr, "%s: Bad date specification\n", cmdname);
				exit(3);
			}
			break;
		case 'i':
			info = *++argv;
			break;
		default:
			fprintf(stderr, "%s: unknown argument %s\n", cmdname, *argv);
			exit(1);
		}
	}
	if ((fptoday = fopen(today, "r")) == NULL) {
		fprintf(stderr, "%s: cannot open today file\n", cmdname);
		exit(2);
	}
	if (getc(fptoday) != MARK) {
		fprintf(stderr, "%s: Mess-up in today file\n", cmdname);
		exit(3);
	}
	while ((bell = inone(inform, fptoday)) >= 0) {
		if (bell)
			fprintf(stdout, "%s", inform);
	}
	fclose(fptoday);
}


/*
 * Read in one 'information packet'
 * If it matchs all defined criteria, return 1
 * Else if it exists return 0
 * Else (error or EOF) return -1
 */
inone(to, fp)
char *to;
FILE *fp;
{
	struct  tm      *localtime();
	struct  tm      *archtime;
	struct  tm      *modtime;
	struct  tm      *acctime;
	char    realname[100];
	char    archname[DIRSIZ + 1];
	char    owner[9];
	char    infoline[MAXLINE];
	char    *toline;
	time_t  archdate;
	time_t  moddate;
	time_t  accdate;
	int     mode;
	int     c;

	/*
	 *  Read a packet
	 */
	fscanf(fp, "%s %s %s %o %d %d %d", realname, archname,
		owner, &mode, &archdate, &moddate, &accdate);
	while ((c = getc(fp)) != NEWLINE && c != EOF)
		;
	if (c == EOF)
		return(-1);
	toline = infoline;
	while ((c = getc(fp)) != MARK && c != EOF)
		*toline++ = c;
	*toline = EOS;
	archtime = localtime(archdate);
	modtime = localtime(moddate);
	acctime = localtime(accdate);
	/*
         *  Check this packet against the criteria
	 */
	if (name != NULL)
                if (sindex(realname, name) == -1)
                        return(0);
	if (date != NULL)
                if (archdate/(24*60*60) != ndate)
			return(0);
	if (info != NULL)
		if (sindex(infoline, info) == -1)
                        return(0);
	if (userid != NULL) {
                if (strcmp(userid, "") != 0 && strcmp(userid, owner) != 0)
                                return(0);
                else if (strcmp(iam, userid) != 0) {
                        if ((mode & PUBREAD) != PUBREAD)
                                if (strcmp(iam, "root") != 0)
                                        return(0);
                }
	} else if (strcmp(iam, owner) != 0)
		return(0);
	/*
         *  Return the packet
	 */
	sprintf(to, "%s %s %s %o %d/%d/%d %d/%d/%d %d/%d/%d\n%s\n",
		realname, archname, owner, mode,
                archtime->tm_mon + 1, archtime->tm_mday, archtime->tm_year,
                modtime->tm_mon + 1, modtime->tm_mday, modtime->tm_year,
                acctime->tm_mon + 1, acctime->tm_mday, acctime->tm_year,
		infoline);
	return(1);
}
