#include "dcon.h"

/*
 * symbol table routines
 */

int nsym = 0;

SYM *insert(p)
char *p;{

	register unsigned h;
	register SYM *s, *last;
	struct arrayelt *a;
	int i;

	if (nsym >= SYMSIZ-1)
		error(1, "symbol table overflow");
	h = hash(p);
	last = NULL;
	s = hashp[h];
	while (s != NULL) {
		last = s;
		s = s->next;
		}
	if ((s = calloc(1, sizeof(SYM))) == NULL)
		error(1, "fatal error: no more memory!");
	if (last == NULL) hashp[h] = s;
	else last->next = s;
	s->next = NULL;
	tokcpy(s->name, p);
	valp[nsym++] = s;
	if (dim != -1) {
		s->type = ARRAY;
		s->val = calloc(1, sizeof(struct arrayelt)); /* elt 0   */
		a = s->val;
		for (i=1; i<dim; i++) {
			a->nexta = calloc(1, sizeof(struct arrayelt));
			a = a->nexta;
		        }
	        a->nexta = NULL;
	        }
	return(s);
	}

SYM *lookup(p)
char *p;{

	register unsigned h;
	register SYM *s;

	h = hash(p);
	s = hashp[h];
	while (s != NULL) {
		if (tokcmp(s->name, p) == 0) return(s);
		s = s->next;
		}
	return(NULL);
	}

SYM *lookuplocal(p)
char *p;{

	register unsigned h;
	register SYM *s;
	char x[10];
	char *xp;

	xp = x;
	while ((*xp++ = *p++) != ':') ;
	--xp;
	*xp = '\0';

	xp = x;


	h = hash(p);
	s = hashp[h];
	while (s != NULL) {
		if ((tokcmp(s->name, p) == 0) &
			(tokcmp(s->func->name,xp) == 0) )  return(s);
		s = s->next;
		}
	return(NULL);
	}

hash(p)
register char *p;{

	register unsigned h;
        register int i = 0;

	for (h = 0; *p != '\0' && i<8; p++) {
		h = (h << 8)+(*p);
		i++;
	}
	return(h%SYMSIZ);
	}

/*
 * comparison routine for qsorting the symbols by value
 */

qcmp(p1, p2)
register SYM **p1, **p2;{

	if ((*p1)->val > (*p2)->val) return(1);
	else if ((*p1)->val < (*p2)->val) return(-1);
	else return(0);
	}


tokcpy(s1, s2)
register char *s1, *s2;{

	register int i = 0;
	while ((*s1++ = *s2++) && i<8) i++;
	}


tokcmp(s1, s2)
register char *s1, *s2;{

	register int i = 0;
	while ((*s1 == *s2) && i<8) {
		if (*s1++ == 0) return(0);
		s2++;
		i++;
	        }
	if (i==8) return(0);
        return(*s1 - *s2);
	}
