#include "dcon.h"

/*
 * printstack - dump a stack trace of a core image
 *	assumes following calling convention:
 *
 *		r10 -> address of current function
 *		r12 -> save area for registers
 *		saved r13 -> arguments
 *		saved r12 -> end of arguments
 */

char *signame[]{
	"Normal termination",
	"Hangup",
	"Interrupt",
	"Quit",
	"Operation exception",
	"Monitor call",
	"Program event",
	"Page translation exception",
	"Floating divide exception",
	"Kill",
	"Specification exception",
	"Segmentation exception",
	"Bad system call",
	"Broken pipe",
	"Alarm clock",
	"Soft kill",
	"Privileged operation exception",
	"Execute exception",
	"Protection exception",
	"Data exception",
	"Fixed point overflow exception",
	"Fixed point divide exception",
	"Decimal overflow exception",
	"Decimal divide exception",
	"Exponent overflow exception",
	"Exponent underflow exception",
	"Significance exception",
	"Out of disk space",
	"Out of system file structures",
	"Program initiation",
	"Svc interrupt",
	};

FILE *out;

printstack(){

	register int p, *i, *savereg;
	register PSTATE *ps = &state;
	int lastfunc, *argp, *lastarg;

	if (offset != CORESTART && trace==0) {
		error(0, "Not a core image");
		return;
		}
	savereg = ps->ps_gpr[12] & STACKTOP;
	lastfunc = ps->ps_gpr[10];
	if (!trace) {
		fprintf(out, "%s at location ", signame[ps->ps_sig]);
		pname(lastfunc, N_EXT+N_TEXT);
		fprintf(out, "+%d\n\n", ps->ps_pc-lastfunc);
		}
	fprintf(out, "stack trace:\n");
	while (savereg != 0) {
		argp = peek(map(savereg+13)) & STACKTOP;
		lastarg = peek(map(savereg+12)) & STACKTOP;
		if (lastarg == 0) lastarg = argp+2;
		fprintf(out, "   ");
		pname(lastfunc, N_EXT+N_TEXT);
		putc('(', out);
		for (i = argp; i < lastarg; i++){
			p = peek(map(i));
			if (PRINST) fprintf(out, "%x", p);
			else if (prtmode == 'l') print((long) p);
			else print(p, 0);
			if (i != lastarg-1) fprintf(out, ", ");
			}
		fprintf(out, ")\n");
		lastfunc = peek(map(savereg+10));
		savereg = peek(map(savereg+12)) & STACKTOP;
		}
	}

/*
 * pname prints the symbol associated with a given address
 *	uses the valp array which is ordered by symbol value
 */

pname(addr, t)
int addr, t;{

	register int off;
	register SYM *s;

	off = vlook(addr, t);
	if (t > 0 && (off == -1 || valp[off]->val != addr))
		off = vlook(addr, N_EXT+t);
	if (off == -1) fprintf(out,"%6x", addr);
	else {
		s = valp[off];
		fprintf(out,"%s", s->name);
		if (s->val != addr)
			fprintf(out,"+%d", addr - s->val);
		}
	}

/*
 * vlook - try to find a symbol near a given address
 * returns the index of the valp array <= to given addr and of type t
 * complexity is from doing a binary search allowing for the
 *	possibility of multiple keys
 */

vlook(addr, t)
int addr, t;{

	register SYM *s;
	register int k, n;
	int i, j;

	i = 0;
	j = nsym-1;
	while (j >= i){
		k = (i+j)/2;
		if ((s = valp[k])->val == addr) {
			if (t == 0 || s->type == t) return(k);
			for (n = k-1; n >= i; n--){
				if ((s = valp[n])->val != addr) break;
				if (s->type == t) return(n);
				}
			for (n = k+1; n <= j; n++) {
				if ((s = valp[n])->val != addr) {
					j = n-1;
					break;
					}
				if (s->type == t) return(n);
				}
			break;
			}
		else if (s->val < addr) i = k+1;
		else j = k-1;
		}
	for (; j >= 0; j--) {
		if (t == 0 || (s = valp[j])->type == t) return(j);
		}
	return(-1);
	}
