/*
 * C compile command
 */

#include <stdio.h>
#include <signal.h>
#include <sys/times.h>

#define CHSPACE 1000
#define NEWPASS0 "/lib/c0"
#define NEWPASS1 "/lib/c1"
#define NEWPASS2 "/lib/c2"

char    *tmp1 = "/tmp/ccaXXXXXX";
char    *tmp2 = "/tmp/ccbXXXXXX";
char    *tmp3 = "/tmp/cccXXXXXX";
char    *tmp4 = "/tmp/ccdXXXXXX";
char    *tmp5 = "/tmp/cceXXXXXX";
char    *mktemp();
char    *outfile;
char    ts[CHSPACE+50];
char    *tsa = ts;
char    *tsp = ts;
char    *av[50];
char    *clist[50];
char    *llist[50];
char    tmplist[50];
int     norway; /* calling Norway C compiler */
int     bingo;
int     compiled;
int     ebcdic;
int     testasm;
int     symtab;
int     pflag;
int     sflag;
int     cflag;
int     eflag;
char    *oflag = NULL;
int     lflag;
int     proflag;
int	tflag;
int     zflag;
int     libflag;        /* don't link in libraries 'libc' and 'liba' for Norway system */
int     dataflag;
int     textflag;
int     exfail;
char    *pass0 = NEWPASS0;
char    *pass1 = NEWPASS1;
char    *pass2 = NEWPASS2;
char    *passp = "/lib/cpp";
char    *pref = "/lib/crt0.o";
char *setsuf(), *copy();

main(argc, argv)
char *argv[]; {

	char *t, tc;
	char *savetsp;
	char *assource;
	char *listing;
	char *rindex();
	char **pv, *ptemp[150], **pvt;
	char textbase[2], database[2];
	int nc, nl, i, j, c, nxo, na, k, retcode;
	int dexit();

	/*
	 * 4 compilers
	 *
	 *      1. occ - old C compiler           for general use
	 *      2. ncc - Norway C compiler        for console group only
	 *      3. tcc - test C compiler          for compiler developers only
	 *      4. cc  - new C compiler           for general use
	 */
	i = nc = nl =  nxo = 0;
	strcpy(textbase, "1");
	strcpy(database, "1");

	/*
	 * establish links to pass0 and pass1
	 */
	t = rindex(argv[0], '\/');
	if (t == 0)
		t = argv[0];
	else
		t = ++t;
	if (*t == 'o') {
		pass0 = 0;                /* occ is a 1 pass compiler */
		pass1 = "/lib/cc";
	}
	else if (*t == 'x') {
		pass0 = "/usr/con/bin/nc0";
		pass1 = "/usr/con/bin/nc1";
		pref = "/usr/con/bin/ncrt0.o";
		norway = 1;
	}
	else if (*t == 'n') {
		pass0 = "/usr/con/bin/ec0";
		pass1 = "/usr/con/bin/ec1";
		ebcdic = 1;
		pref = "/usr/con/bin/ecrt0.o";
	}
	else if (*t == 't') {
		pass0 = "/usr/src/lib/c/c0/c0";
		pass1 = "/usr/src/lib/c/c1/c1";
	}
	else if (*t == 'a') {
		testasm = 1;
	}

	pv = ptemp;
	while(++i < argc) {
		if(*argv[i] == '-')
			/*
			 * compiler and loader options
			 */
		        switch (argv[i][1]) {
			case 'S':
				/*
				 * compiler option - put assembly output in '.s' file
				 */
				sflag++;
				cflag++;
				continue;
			case 'o':
				/*
				 * link option - use name following '-o' for 'ld' output file
				 */
				if (++i < argc) {
					outfile = argv[i];
					/*
					 * get suffix (i.e. character after '.' of the file name
					 */
					if ((tc=getsuf(outfile))=='c'||tc=='o') {
						error("Would overwrite %s",
							outfile);
						exit(8);
					}
				}
				continue;
			case 'O':
			        /*
			         * compiler option - call optimizer
			         */
				oflag = argv[i];
				continue;
			case 'L':
			        /*
			         * assembler option - produce listing
			         */
				lflag++;
				continue;
			case 'p':
				proflag++;
				pref = "/lib/crt0.o";
				continue;
			case 'P':
				/*
				 * compiler option - run preprocessor only - leave output in '.i' file
				 */
				pflag++;
				*pv++ = argv[i];
			case 'c':
				/*
				 * compiler option - suppress loading phase - produce '.o' object file
                                 */
				cflag++;
				continue;

			case 'f':
				pref = "/lib/fcrt0.o";
				pass0 = "/lib/fc0";
				pass1 = "/lib/fc1";
				continue;

			case 'D':
			        if (argv[i][2] == 'R') {
					strcpy(database, argv[i]+3);
					dataflag++;
                                        continue;
				}
			case 'I':
			case 'U':
			case 'W':
				/*
				 * compiler options
				 */
				*pv++ = argv[i];
				continue;
			case 't':
				tflag++;
				continue;

			case 'z':
				if (norway || ebcdic)
					zflag++;
				continue;

			case 'A':
				if (norway || ebcdic)
					libflag++;
				continue;

			case 'T':
			        if (argv[i][2] == 'R') {
					strcpy(textbase, argv[i]+3);
					textflag++;
				}
				else if (norway || ebcdic)
				        symtab++;
				continue;
		}
		t = argv[i];                         /* file name */
		if((c=getsuf(t))=='c' || c=='s') {
			clist[nc++] = t;
			t = setsuf(t, 'o');
		}
		if (nodup(llist, t)) {
			llist[nl++] = t;
			if (getsuf(t)=='o')
				nxo++;
		}
	}
	if(nc==0)
		goto nocom;
        if (signal(SIGINTR, SIG_IGN) != SIG_IGN)
                signal(SIGINTR, dexit);
        if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
                signal(SIGQUIT, dexit);
        if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
                signal(SIGHUP, dexit);
	signal(SIGTERM, dexit);
	signal(SIGNOSPC, dexit);
	tmp1 = mktemp(tmp1);
	tmp2 = mktemp(tmp2);
	tmp3 = mktemp(tmp3);
	if (oflag != NULL)
		tmp5 = mktemp(tmp5);
	if (pflag==0)
		tmp4 = mktemp(tmp4);
	pvt = pv;
	for (i=0; i<nc; i++) {
		fflush(stdout);
		exfail = 0;
		if (nc>1)
			printf("%s:\n", clist[i]);
		if (getsuf(clist[i])=='s') {
			assource = clist[i];
			goto assemble;
		} else
			assource = tmp3;

	/*
	 * do preprocessor stage
	 * leave output in name.i if -P is specified
	 */
	  compile:
		if (pflag)
			tmp4 = setsuf(clist[i], 'i');
		savetsp = tsp;
		av[0] = "cpp";
		av[1] = clist[i];
		av[2] = tmp4;
		na = 3;
		for(pv=ptemp; pv <pvt; pv++)
			av[na++] = *pv;
		av[na++]=0;
		if (callsys(passp, av)) {
			exfail++;
			eflag++;
		}
		if (pflag || exfail) {
			cflag++;
			continue;
		}

	/*
	 * call the compiler
	 * some fudging for an old one-pass compiler
	 */
		av[1] = tmp4;
		tsp = savetsp;
		if (sflag)
			assource = tmp3 = setsuf(clist[i], 's');
		if (pass0){
			compiled++;
			av[0] = "c0";
			av[2] = tmp1;
			av[3] = tmp2;
			k = 4;
			if (proflag)
				av[k++] = "-P";
		        if (lflag)
		                av[k++] = "-L";
			if (dataflag) {
				av[k++] = "-D";
				av[k++] = database;
			}
			if (textflag) {
				av[k++] = "-T";
				av[k++] = textbase;
			}
			av[k] = 0;
			if (callsys(pass0, av)) {
				cflag++;
				eflag++;
				continue;
			}
			av[1] = tmp1;
			av[2] = tmp2;
			av[3] = (oflag != NULL) ? tmp5 : tmp3;
			av[4] = 0;
		}
		else {
			av[2] = (oflag != NULL) ? tmp5 : tmp3;
			av[3] = 0;
		}
		av[0] = "c1";
		if (callsys(pass1, av)) {
			cflag++;
			eflag++;
			continue;
		}
		if (oflag != NULL) {
			av[0] = "c2";
                        av[1] = oflag;
                        av[2] = tmp5;
                        av[3] = tmp3;
                        av[4] = 0;
			if(callsys(pass2, av)) {
				unlink(tmp3);
				tmp3 = assource = tmp5;
			} else {
				unlink(tmp5);
			}
		}
		if (sflag)
			continue;

	/*
	 * call the assembler
	 * the "-u" specified undefineds are to be treated as externals
	 */
	assemble:
		if (lflag) {
			char *t;

			listing = setsuf(clist[i], 'l');
			t = tmplist;
			while(*t++ = *listing++)
			        ;
			*--t = 's';
			*++t = 't';
			*++t = '\0';
			listing = tmplist;
		}
		av[0] = "as";
		av[1] = "-u";
		av[2] = "-o";
		av[3] = setsuf(clist[i], 'o');
		k = 4;
		if (compiled && !norway && !ebcdic)
			av[k++] = "-C";
		if (lflag) {
			av[k++] = "-L";
			av[k++] = listing;
		        av[k++] = assource;
		        av[k++] = 0;
		}
		else {
		        av[k++] = assource;
		        av[k++] = 0;
		}
		unlink(tmp1);
		unlink(tmp2);
		unlink(tmp4);
		if (norway) {
		        if (callsys("/usr/con/bin/nas", av) > 1) {
			        cflag++;
			        eflag++;
			        continue;
		        }
		}
		else if (ebcdic) {
		        if (callsys("/usr/con/bin/eas", av) > 1) {
			        cflag++;
			        eflag++;
			        continue;
		        }
		}
		else if (testasm) {
			if ((retcode = callsys("/usr/src/cmd/as/as", av)) > 1) {
				if (retcode == 2) {
					textbase[0] = textbase[0] + 1;
					textflag++;
					bingo++;
					goto compile;
				}
				else if (retcode == 3) {
					database[0] = database[0] + 1;
					dataflag++;
					bingo++;
					goto compile;
				}
				else {
				        cflag++;
				        eflag++;
				        continue;
				}
			}
		}
		else if ((retcode = callsys("/bin/as", av)) > 1) {
			if (retcode == 2) {
				textbase[0] = textbase[0] + 1;
				textflag++;
				bingo++;
				goto compile;
			}
			else if (retcode == 3) {
				database[0] = database[0] + 1;
				dataflag++;
				bingo++;
				goto compile;
			}
			else {
			        cflag++;
			        eflag++;
			        continue;
			}
		}
	}
	if (bingo)
		fprintf(stderr, "\n\tBase registers used - %d for text, %d for data\n\n", atoi(textbase), atoi(database));
/*
 * everybody's compiled, now we link & load with "ld"
 */
nocom:
	if (cflag==0 && nl!=0) {
		i = 0;
		av[0] = "ld";
		av[1] = "-X";
		if (zflag)
			j = 2;
		else {
		        av[2] = pref;
		        j = 3;
		}
		if ((norway || ebcdic) && !symtab)
			av[j++] = "-s";
		if (outfile) {
			av[j++] = "-o";
			av[j++] = outfile;
		}
		while(i < nl)
			av[j++] = llist[i++];
		av[j++] = "-lc";
		if ((norway && libflag) || ebcdic)
			/*
			 * leave off libraries
			 */
			j--;
	        if (norway && (libflag==0))
		        av[j++] = "-la";
		av[j++] = 0;
		if (ebcdic)
		        eflag |= callsys("/usr/con/bin/eld", av);
		else if (norway)
		        eflag |= callsys("/usr/con/bin/nld", av);
		else
		        eflag |= callsys("/bin/ld", av);
		if (nc==1 && nxo==1 && eflag==0)
			unlink(setsuf(clist[0], 'o'));
	}
	dexit(eflag);
}

dexit(retcode)
int retcode;
{
	if (!pflag) {
		unlink(tmp1);
		unlink(tmp2);
		if (sflag==0)
			unlink(tmp3);
		unlink(tmp4);
		unlink(tmp5);
	}
	exit(retcode);
}

/*VARARGS*/
error(s, x)
char *s, *x;
{
	fprintf(stderr, s, x);
	fprintf(stderr, "\n");
	exfail++;
	cflag++;
	eflag++;
}

getsuf(as)
char as[];
{
	register int c;
	register char *s;
	register int t;

	s = as;
	c = 0;
	while(t = *s++)
		if (t=='/')
			c = 0;
		else
			c++;
	s -= 3;
	if (c<=14 && c>2 && *s++=='.')
		return(*s);
	return(0);
}

char *setsuf(as, ch)
char as[];
{
	register char *s, *s2;

	s = s2 = copy(as);
	while(*s)
		if (*s++ == '/')
			s2 = s;
	s[-1] = ch;
	return(s2);
}

callsys(f, v)
char f[], *v[]; {
	int t, status;
	struct tms tstart, tnow;

#ifdef DEBUG
	printf(">%s ", f);
	while (*++v) printf("%s ", *v);
	putchar('\n');
	return(0);
#endif
	fflush(stdout);
	if (tflag) times(&tstart);
	if ((t=fork())==0) {
		execv(f, v);
		printf("Can't exec %s\n", f);
		exit(100);
	} else
		if (t == -1) {
			printf("Try again\n");
			return(100);
		}
	while(t!=wait(&status));
	if ((t=(status&0177)) != 0 && t!=SIGALRM) {
		if (t != SIGINTR){
			printf("Fatal error %d in %s\n", t, f);
			eflag = 8;
		}
		dexit(eflag);
	}
	if (tflag){
		times(&tnow);
		printf("%s:\tuser = %7.03f, sys = %7.03f\n", f,
			(double)(tnow.tms_cutime-tstart.tms_cutime)/1000000.,
			(double)(tnow.tms_cstime-tstart.tms_cstime)/1000000.);
	}
	return((status>>8) & 0377);
}

char *copy(as)
char as[];
{
	register char *otsp, *s;
	char *malloc();

	otsp = tsp;
	s = as;
	while(*tsp++ = *s++);
	if (tsp >tsa+CHSPACE)
		{
		tsp = tsa = malloc(CHSPACE+50);
		if (tsp == NULL){
			error("no space for file names");
			dexit(eflag);
			}
		}
	return(otsp);
}

nodup(l, os)
char **l, *os;
{
	register char *t, *s;
	register int c;

	s = os;
	if (getsuf(s) != 'o')
		return(1);
	while(t = *l++) {
		while(c = *s++)
			if (c != *t++)
				break;
		if (*t=='\0' && c=='\0')
			return(0);
		s = os;
	}
	return(1);
}

itoa(n, s)
char s[];
register int n;
{
	register i, sign;

	if ((sign = n) < 0)
		n = -n;
	i = 0;
	do {
		s[i++] = n % 10 + '0';
	} while ((n /= 10) > 0);
	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';
	reverse(s);
}

reverse(s)
char s[];
{
	register c, i, j;

	for (i = 0, j = strlen(s)-1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}
