/*
 * Convert a Roman numeral string to an integer.
 * Returns -1 for erroneous string.
 */
rtoi(s)
char *s;
{
	int n, last, val, pow10, dec, contig;
	char *p;
	for(p = s; *p; p++);
	last = n = 0;
	while(--p >= s) {
		switch(*p) {
		case 'i': case 'I':
			val = 1; pow10 = 1; break;
		case 'v': case 'V':
			val = 5; pow10 = 0; break;
		case 'x': case 'X':
			val = 10; pow10 = 1; break;
		case 'l': case 'L':
			val = 50; pow10 = 0; break;
		case 'c': case 'C':
			val = 100; pow10 = 1; break;
		case 'd': case 'D':
			val = 500; pow10 = 0; break;
		case 'm': case 'M':
			val = 1000; pow10 = 1; break;
		case 'w': case 'W':
			val = 5000; pow10 = 0; break;
		case 'z': case 'Z':
			val = 10000; pow10 = 1; break;
		default:
			return(-1);
		}
		if(val > last) {
			n =+ val;
			dec = 0;
			contig = 1;
			last = val;
		} else if(val == last) {
			if(!pow10 || ++contig > 3) return(-1);
			n =+ val;
		} else {
			if(!pow10 || contig != 1 || dec) return(-1);
			dec = 1;
			contig = 0;
			n =- val;
		}
	}
	return(n);
}
