/*
 * Convert an integer to Roman numerals
 * Maximum value which can be converted is 38888 (ZZZWMMMDCCCLXXXVIII).
 */
#define NROM 5
itor(n, up)
{
	static char rnum[25];
	int rem[NROM], prev[NROM];
	char *cp, *ones, *fives;
	int i, k;

	ones = up? "IXCMZ": "ixcmz";
	fives = up? "VLDW": "vldw";
	for(i=0; i<NROM; i++) {
		rem[i] = n % 10;
		n =/ 10;
		prev[i] = -1;
	}
	for(i=0; i<NROM; i++) {
		if(rem[i] == 9) {
			if(prev[i] == -1)
				prev[i+1] = i;
			else {
				prev[i+1] = prev[i];
				prev[i] = -1;
			}
			rem[i] = 0;
		}
	}
	cp = rnum;
	for(i = NROM-1; i >= 0; i--) {
		if(rem[i] == 4) {
			if(prev[i] == -1) *cp++ = ones[i];
			else *cp++ = ones[prev[i]];
			*cp++ = fives[i];
		} else {
			k = rem[i] % 5;
			if(rem[i] >= 5) *cp++ = fives[i];
			while(k--) *cp++ = ones[i];
			if(prev[i] != -1) {
				*cp++ = ones[prev[i]];
				*cp++ = ones[i];
			}
		}
	}
	*cp = '\0';
	return(rnum);
}
