/*
 * RESTore File System
 *
 */
#include <stdio.h>
#include <sgtty.h>
#include <sys/param.h>

#define TAPEBLK	(60*1024)		/* 60k block size on tape */
#define HEADERSIZE BSIZE
#define BLKTBLK	(TAPEBLK/BSIZE)		/* disk blocks per tape block */

#define fsf(a)  ioctl(a, TAPIO, 0x3f);

char area[4*TAPEBLK];                   /* Make room for 3350's */

struct disklist {
	char device[20];
	char filesys[40];
	int  blks;
};
/*
 *  This structure is filled in by the FASTSIZE ioctl for a fast disk.
 */
struct dsize {
	int nblks;              /* number of blocks on the file system */
	int blk_trk;            /* number of blocks/track */
} dsize;

char header[HEADERSIZE];
char tapename[100];
char *toin;
char usage[] = "Usage : %s [-e] [-t] tape file_system fdasd\n";
char devtape[] = "/dev/tape";

int     count;
int     resid;
int     eflag;
int     tflag;

extern int errno;
extern char *cmdname;

main(argc, argv)
int argc;
char *argv[];
{
	int	fdin;
	char	*toout;
	char	*tosys;
	char	*lbl;
	char	*labelchk();

	while (**++argv == '-')  {
		switch(*++*argv) {
		case 'e' :
			eflag++;
			break;
		case 't' :
			tflag++;
			break;
		default:
			fprintf(stderr, "%s: unknown argument %c\n", cmdname, **argv);
			exit(1);
		}
		argc--;
	}
	fdin = opentape(*argv);
	/*
	 *  See if the label is ok.
	 */
	if ((lbl = labelchk(fdin, toin)) != NULL) {
		fprintf(stderr, "%s: Label conflict: %s %s.\n", cmdname, toin, lbl);
		exit(4);
	}

	if (tflag) {
		if (argc != 2) {
			fprintf(stderr, usage, cmdname);
                        exit(1);
                }
		toc(fdin);
		exit(0);
	}
	if (argc != 4) {
                fprintf(stderr, usage, cmdname);
		exit(1);
	}
	tosys  = *++argv;
	toout  = *++argv;
	rdfilsys(fdin, tosys, toout);
}
/*
 *  opentape - open the tape device
 */
opentape(name)
char    *name;
{
	char    *sname();
	int     fdin;

	if (*name != '/')
                sprintf(tapename, "/dev/tape/%s", name);
	else
                sprintf(tapename, "%s", name);

	if (strncmp(tapename, devtape, strlen(devtape)) != 0) {
		fprintf(stderr, "%s: %s is not a tape device.\n", cmdname, tapename);
		exit(2);
	}

	if ((fdin = open(tapename, 0)) < 0) {
		fprintf(stderr, "%s: Cannot open %s for reading.\n", cmdname, tapename);
		exit(2);
	}

	toin = sname(tapename);
	return(fdin);
}
/*
 *  rdfilsys - read the file system off tape.
 *  We want to write to the disk one track at a time.
 *  Stofs stores the files system in 60k blocks which
 *  are 15 file system blocks.
 *  Determine the type of disk we are restoring to and
 *  the number of blocks (4k) per track on it.
 *  Make as many tape reads as necessary to be able to
 *  write in full track units.
 */
rdfilsys(fdin, tosys, toout)
int     fdin;
char    *tosys;
char    *toout;
{
	int     reads;          /* number of tape reads between writes */
	int     writes;         /* number of disk writes between reads */
	int     track;          /* the size of a track */
	int     rd;
	int	blocks;
	int     i, j, k;
	int     fdout;
	int     size;
	int     ourdp;
	struct  disklist *dp;

	if ((fdout = open(toout, 1)) < 0) {
		fprintf(stderr, "%s: Cannot open %s for writing.\n", cmdname, toout);
		exit(8);
	}
        if (ioctl(fdout, FASTSIZE, &dsize) == -1) {
                fprintf(stderr, "%s: %s: could not obtain size\n", cmdname, toout);
                exit(3);
        }
	reads = 1;
	if (!eflag) {
		if (ioctl(fdout, FASTFORM, &size) == -1) {
			fprintf(stderr, "%s: %s not a fast dasd.\n", cmdname, toout);
			exit(3);
		}
		if (BLKTBLK%dsize.blk_trk != 0) {
			reads = dsize.blk_trk;
			if (sizeof(area) < reads*TAPEBLK) {
				fprintf(stderr, "%s: %s: %d block/track exceeds internal array\n", cmdname, toout, dsize.blk_trk);
				exit(4);
			}
		}
	}
	writes = (reads*BLKTBLK)/dsize.blk_trk;
	track = dsize.blk_trk*BSIZE;
	ourdp = before(fdin, tosys);
	if (header[0] != '/')
                dp = (struct disklist *) (header + sizeof(time_t));
	else
		dp = (struct disklist *) header;
	/*
	 *  Position the tape at the beginning of the filesystem to get.
	 *  Skip to the tape mark at the end of the header.
	 */
	fsf(fdin);
	i = 0;
	while (i++ < ourdp)
		fsf(fdin);
	/*
         *  Read in the file system
         */
        count = dp[ourdp].blks / BLKTBLK;
	for (i = 0; i <= count - reads; i += reads) {
		for (rd = 0; rd < reads; rd++) {
	                if ((j = read(fdin, &area[rd*TAPEBLK], TAPEBLK)) != TAPEBLK) {
				fprintf(stderr, "%s: Read error. count %d i %d j %d \n", cmdname, count, i, j);
				exit(6);
			}
		}
		for (j = 0; j < writes; j++) {
                        if ((k = write(fdout, &area[j*track], track)) != track) {
                                fprintf(stderr, "%s: Write error i %d count %d j %d k %d errno %d\n", cmdname, i, count, j, k, errno);
                                exit(7);
                        }
		}
	}
	/*
         *  Handle anything left over.
	 */
	for (rd = 0; rd < count - i; rd++) {
                if (read(fdin, &area[rd*TAPEBLK], TAPEBLK) != TAPEBLK) {
                        fprintf(stderr, "%s: Read error. count %d i %d rd %d \n", cmdname, count, i, rd);
			exit(6);
		}
	}
	resid = dp[ourdp].blks % BLKTBLK;
	if (resid > 0) {
                if ((j = read(fdin, &area[rd*TAPEBLK], resid*BSIZE)) != resid*BSIZE) {
                        fprintf(stderr, "%s: Read error. resid %d j %d\n", cmdname, resid, j);
                        exit(6);
                }
	}
        blocks = rd*BLKTBLK + resid;
        writes = blocks/dsize.blk_trk;
        for (j = 0; j < writes; j++) {
                if (k = (write(fdout, &area[j*writes], track) != track)) {
                        fprintf(stderr, "%s: Write error resid %d errno %d k %d\n", cmdname, resid, errno, k);
                        exit(7);
                }
        }
	close(fdin);
	close(fdout);
}

/*
 *  Read the first block (HEADERSIZE)
 *  The file system names and their sizes (in order)
 */
before(fd, flsys)
int fd;
char *flsys;
{
	struct  disklist *dp;
	int     i;

	fsf(fd);
	if ((i = read(fd, header, HEADERSIZE)) != HEADERSIZE) {
		fprintf(stderr, "%s: %s not a stofs tape: %d\n", cmdname, toin, i);
		exit(9);
	}
	if (header[0] != '/')
                dp = (struct disklist *) (header + sizeof(time_t));
	else
		dp = (struct disklist *) header;
	i = 0;
	while (*dp->device) {
		if (strcmp(dp->filesys, flsys) == 0)
			return(i);
		i++;
		dp++;
	}
        fprintf(stderr, "%s: %s: not stofs'ed on %s.\n", cmdname, flsys, toin);
        exit(5);
	return(i);                      /* for lint */
}
/*
 *  toc - Print the table of contents from the header block
 *  First, read until the tape make at the end of the header.
 */
toc(fdin)
int fdin;
{
	struct  disklist *dp;
	char    *ctime();
	int     i = 0;

        fsf(fdin);
	if ((i = read(fdin, header, HEADERSIZE)) != HEADERSIZE) {
		fprintf(stderr, "%s: %s not a stofs tape: %d\n", cmdname, toin, i);
		exit(9);
	}
	if (header[0] != '/') {
                fprintf(stdout, "%s", ctime(((time_t *) header)[0]));
                dp = (struct disklist *) (header + sizeof(time_t));
	} else
		dp = (struct disklist *) header;
	while (*dp->filesys) {
		fprintf(stdout, "%s %d\n", dp->filesys, dp->blks);
                dp++;
        }
}
