/*
 * run command in background
 */

#include <stdio.h>
#include <sys/times.h>
#include <signal.h>

#define CMDLEN          200
#define MSGLEN          300

char    cmd[CMDLEN];
char    msg[MSGLEN];
char    *cmdp           cmd;
char    *logname;
char    *usage = "Usage: back [-n] [-t] command [args...]\n";

int     status;
int     nflag;
int     tflag;
int     notifyflg;
int     hup();

main (argc, argv)
int     argc;
char    **argv;
{
        int     pid;
        int     i;
	char    *cp;

        if (argc < 2) {
                fprintf(stderr, usage);
                exit (1);
        }
	/*
         * Check for arguments.
	 */
        if (**++argv == '-') {
		cp = *argv;
		while (*++cp)
			switch (*cp) {
			case 'n':
				nflag++;
				break;
			case 't':
				tflag++;
				break;
			default:
			        fprintf(stderr, usage);
				exit(1);
			}
                argv++;
                argc--;
	}
	logname = getlogin();
	/*
         * Fork process which will never be waited for.
         * This is what really sends it into the background.
	 */
        if ((pid = fork()) == 0) {
                signal(SIGINTR, SIG_IGN);
		/*
                 * Redirect standard input to /dev/null.
                 * Background processes shouldn't read the terminal.
		 */
                close(0);
                open("/dev/null", 0);
		/*
                 * Set up command line for shell.
		 */
                while (--argc) {
                        while (**argv)
                                *cmdp++ = *(*argv)++;
                        *cmdp++ = ' ';
                        argv++;
                }
                *--cmdp = '\0';
		/*
                 * If nflag, run as nohup - immune to quits and hangups.
		 */
                if (nflag) {
                        signal(SIGQUIT, SIG_IGN);
                        signal(SIGHUP, SIG_IGN);
                }
		/*
                 * Fork process which passes the command to the shell.
		 */
                if ((pid = fork()) == 0) {
                        execl ("/bin/sh", "back.shell", "-ec", cmd, 0);
                        fprintf(stderr, "Back: cannot exec shell\n");
                        exit (1);
                }
                if (pid < 0) {
                        fprintf(stderr, "Back: cannot fork\n");
                        exit (1);
                }
		/*
                 * Turn off quits and hangups so message can be generated
                 * even if user quits or hangs up.
		 */
                signal(SIGQUIT, SIG_IGN);
                signal(SIGHUP, hup);
		/*
                 * Wait for shell, which will terminate after the
                 * command does.
		 */
                while ((i = wait(&status)) != pid && i != -1)
			;
		if (notifyflg == 3)
	                while ((i = wait(&status)) != pid && i != -1)
			        ;
		status &= 0xffff;
		if (tflag)
	                sprintf(msg, "\"%s\" took %s seconds and ended with return code %x",
	                        cmd, sec(), status);
		else
	                sprintf(msg, "\"%s\" ended with return code %x",
	                        cmd, status);
                notify(logname, msg, notifyflg);
                exit (0);
        }
        if (pid < 0) {
                fprintf(stderr, "Back: cannot fork\n");
                exit (1);
        }
        exit (0);
}

sec()
{
	struct  tms tms;
	static  char obuf[20];
	double  time;

	times(&tms);
	time = (tms.tms_cutime + tms.tms_cstime) / 1e6;
	sprintf(obuf, "%.03f", time);
	return (obuf);
}

/*
 * If user hangs up, notify only to mail file.
 */
hup()
{
	notifyflg = 3;
}
