/* ascii -- outputs arbitrary ascii characters
 *
 */

#include <stdio.h>

#define NC 36

main(argc, argv)
int argc;
char *argv[];
{
	char *arg;
	int i;
	static struct character {
		char *name;
		char value;
	} ch[NC] = {
		"ff",  '\014',
		"bel", '\007',
		"nl",  '\012',
		"lf",  '\012',
		"ga",  '\140',
		"sp",  '\040',
		"esc", '\033',
		"bs",  '\010',
		"ht",  '\011',
		"vt",  '\013',
		"cr",  '\015',
		"so",  '\016',
		"si",  '\017',
		"nul", '\000',
		"soh", '\001',
		"stx", '\002',
		"etx", '\003',
		"eot", '\004',
		"enq", '\005',
		"ack", '\006',
		"dle", '\020',
		"dc1", '\021',
		"dc2", '\022',
		"dc3", '\023',
		"dc4", '\024',
		"nak", '\025',
		"syn", '\026',
		"etb", '\027',
		"can", '\030',
		"em",  '\031',
		"sub", '\032',
		"fs",  '\034',
		"gs",  '\035',
		"rs",  '\036',
		"us",  '\037',
		"del", '\177',
	};

	while (--argc) {
		++argv;
		arg = *argv;
		if (arg[1] == '\0') {
			putchar(*arg);
		} else if ('0'<=*arg && *arg<='7') {
			i = *arg - '0';
			while (*++arg != '\0') {
				if ('0'<=*arg && *arg<='7')
					i = 8*i + (*arg-'0');
				else
					error(*argv);
			}
			if (i < 256)
				putchar(i);
			else
				error(*argv);
		} else {
			for (i=0; i<NC; i++) {
				if (strcmp(arg, ch[i].name) == 0) {
					putchar(ch[i].value);
					break;
				}
			}
			if (i == NC)
				error(arg);
		}
	}
}

error(arg)
char *arg;
{
	fprintf(stderr, "ascii:  invalid argument (%s)\n", arg);
	exit(1);
}
