#include <stdio.h>
#include "sym.h"
#include "scanner.h"
 
/*
 * pass 1 scanner for assembler
 */

int ready = 1;
int printc = 1;
int dccount = 1;
int comment;
int almostready;        /* used to check for instructions such as */
			/* ssm =x'03' which must not be confused with */
			/* an equate.The equal sign (=) must be checked */
			/* only directly after an instruction, not in */
			/* a situation such as "l   2,=f'4'". This */
			/* entire kludge only applies to listings */

static char ctab[] = {
	 UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN,
	 UNKN,BLANK,NEWLINE,UNKN,UNKN, UNKN, UNKN, UNKN,
	 UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN,
	 UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN, UNKN,
	BLANK,OTHER, ALPH, ALPH, ALPH, ALPH, ALPH,   SQ,
	OTHER,OTHER,OTHER,OTHER,OTHER,OTHER,  DOT,SLASH,
	DIGIT,DIGIT,DIGIT,DIGIT,DIGIT,DIGIT,DIGIT,DIGIT,
	DIGIT,DIGIT,COLON, SEMI,OTHER,OTHER,OTHER, ALPH,
	 ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH,OTHER,BACKSLASH,OTHER,OTHER,ALPH,
	OTHER, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH, ALPH,
	 ALPH, ALPH, ALPH,OTHER,OTHER,OTHER, ALPH, UNKN,
	};

scan1(s, context)
register TOKEN *s;
int context;{

	register int c;
	register char *p;
	register SYM *t;
	int ct;
	int lflag, oplntype;

	lflag = 0;
	p = s->t_name;
	for (;;) {
		while ((c = nextchar()) == EOF) {
			putw(START, txtfil);
		        while (--nargs > 0 && (infil = fopen(*++curarg, "r")) == NULL)
				printf("Can't open %s\n", *curarg);
			if (nargs <= 0) {
				s->t_state = END;
				return;
				}
			if (errflg) errflg = -1;
			lineno = 1;
			}
		switch(ctab[c&0177]) {
			case BLANK:
				continue;
			case UNKN:
				error(0, "Unknown character");
				continue;
			case ALPH:
				if (c == '~') {
					lflag = 1;
					if (listflg && ready)
						setype("~");
					}
				else *p++ = c;
			idloop:
				while ((c = nextchar()) != EOF) {
                                        ct = ctab[c];
					if (ct!=ALPH && ct!=DIGIT && ct!=DOT)
						break;
					*p++ = c;
					}
				*p = '\0';
				if (listflg && ready)
					/*
					 * set lntype
					 */
				        setype(s->t_name);
				if (c == '\'') {
					getcon(s);
					puttxt(s);
					ready = 0;
					return;
					}
				ungetc(c, infil);
				peekchar = 1;
				s->t_namep = p-(s->t_name);
				p = s->t_name;
				if (context==0 && !lflag) {
					if ((t = lookup(p, OPCODE)) != NULL) {
						s->t_sym = t;
						s->t_val = 0;
						s->t_state = ID;
						puttxt(s);
				                if (ready) {
					                almostready = 1;
					                lntype = t->s_type;
					                oplntype = lntype;
					                ready = 0;
					        }
						return;
					}
                                        else if (ready) {
					        almostready = 0;
                                                lntype = 0;
						ready = 0;
					}
				}
				s->t_val = -1;
				if (lflag) {
					*p += 0200;
					s->t_sym = usersym(p, UNDEFINED, 0, 0);
					}
				else if ((s->t_sym = lookup(p, USYM)) == NULL)
					s->t_sym = usersym(p, UNDEFINED, 0, 0);
				s->t_state = ID;
				if (ready) {
				        almostready = 0;
				        lntype = c;
				        ready = 0;
				        }
				break;
			case DIGIT:
			        almostready = 0;
				if ((s->t_val = getnum(c-'0')) < 10)
					s->t_state = DIG;
				else s->t_state = ABS;
				break;
			case DOT:
			        almostready = 0;
				c = nextchar();
				if (ctab[c] != ALPH) {
				        if (listflg && ready) {
					        lntype = 0;
					        ready = 0;
				        }
					ungetc(c, infil);
				        peekchar = 1;
					s->t_state = ADOT;
					puttxt(s);
					return;
					}
				p = s->t_name;
				*p++ = '.';
				*p++ = c;
				goto idloop;
			case SLASH:
			        almostready = 0;
				if (listflg && ready) {
					lntype = -9;
					ready = 0;
				}
				comment = 1;
				while ((c = nextchar()) != EOF && c != NEWLINE);
				comment = 0;
				if (c == EOF) s->t_state = END;
				else {
					s->t_state = NEWLINE;
					if (listflg) {
					        ready = 1;
					        if (printc == 0)
						        printc = 1;
					        else {
					                prtwrd(lntype);
					                prtwrd(lineno);
                                                        if (lntype == -2 /* dc or ds */) {
					                        prtwrd(dccount);
                                                                dccount = 1;
                                                        }
					        }
					        lntype = 0;
					}
					lineno++;
					puttxt(s);
					}
				return;
			case BACKSLASH:
			        almostready = 0;
				if ((c = nextchar()) == EOF)
					s->t_state = END;
				else {
					s->t_state = c;
					puttxt(s);
					}
				return;
			case NEWLINE:
			        almostready = 0;
				s->t_state = NEWLINE;
				if (listflg) {
					peekchar = 0;
					ready = 1;
					if (printc == 0)
						printc = 1;
					else {
					        prtwrd(lntype);
					        prtwrd(lineno);
                                                if (lntype == -2 /* dc or ds */) {
				                        prtwrd(dccount);
                                                        dccount = 1;
                                                }
					}
					lntype = 0;
				}
				lineno++;
				break;
			case SEMI:
			        almostready = 0;
				s->t_state = ';';
				puttxt(s);
				s->t_state = NEWLINE;
				return;
			case COLON:
			        almostready = 0;
				lntype = -4;
				ready = 1;
			case OTHER:
				if ((c == '=') && almostready)
					lntype = oplntype;
				if ((c == ',') && lntype == -2 /* dc or ds */)
					dccount++;
			        almostready = 0;
				s->t_state = c;
				break;
			case SQ:
			        almostready = 0;
				s->t_state = SQS;
				break;
			default:
			        almostready = 0;
				printf("type %d for %d found\n", ctab[c], c);
				error(1, "Assembler error: scan1");
				exit(2);
			}
		puttxt(s);
		return;
		}
	error(1, "Can't get here");
	s->t_state = END;
	}

puttxt(toke)
register TOKEN *toke;{

	register char *p, *q;

	switch(toke->t_state){
	        case ID:
	                if (toke->t_val == -1)
	                        putw(USYMSTART, txtfil);
	                else putw(SYMSTART, txtfil);
			putw(toke->t_sym, txtfil);
	                break;
	        case DIG:
	        case ABS:
	                putw(toke->t_state, txtfil);
	                putw(toke->t_val, txtfil);
	                break;
		case BIN:
	        case HEX:
	        case CHAR:
	                putw(toke->t_state, txtfil);
			putw(toke->t_val, txtfil);
	                p = toke->t_name;
			q = p+toke->t_val;
	                while (p < q) putc(*p++, txtfil);
	                putc(SQS, txtfil);
	                break;
		case FQ:
		case HQ:
			putw(toke->t_state, txtfil);
			putw(toke->t_val, txtfil);
			break;
	        default:
	                putw(toke->t_state, txtfil);
	                break;
	        }
	}

/*
 * read a number
 */

getnum(n)
register int n;{

	register int c;

	while ((c = nextchar()) != EOF && c >= '0' && c <= '9')
		n = 10*n+(c-'0');
	ungetc(c, infil);
	peekchar = 1;
	return(n);
	}

/*
 * read a constant
 */

getcon(s)
register TOKEN *s;{

	register int c;
	register char *p, *q;

	p = s->t_name;
	if ((c = *(p+1)) != '\0') {
		if (c != 'l' && c != 'L')
			error(0, "Bad constant specification");
		s->t_val = 0;
		for (q = p+2; *q >= '0' && *q <= '9'; q++)
			s->t_val = 10*s->t_val+(*q-'0');
		}
	else s->t_val = dslen(*p);
	switch(*p) {
		case 'f':
		case 'F':
			s->t_state = FQ;
			return;
		case 'h':
		case 'H':
			s->t_state = HQ;
			return;
		case 'd':
		case 'D':
			s->t_state = DQ;
			return;
		case 'l':
		case 'L':
			s->t_state = LQ;
			return;
		case 'b':
		case 'B':
			s->t_state = BIN;
			while ((c = nextchar()) == '0' || c == '1')
				if (p < (s->t_name+LINESIZE)) *p++ = c;
			if (c == EOF || c == NEWLINE)
				error(0, "Non-terminated constant");
			if (c != '\'')
				error(0, "Bad binary constant");
			s->t_namep = p-(s->t_name);
			s->t_val = pack(s);
			return;
		case 'x':
		case 'X':
			s->t_state = HEX;
			while ((c = nextchar()) != EOF) {
				if (c>='A' && c<='F') c = c-'A'+'a';
				if ((c>='0' && c<='9')||(c>='a' && c<='f')) {
					if (p < (s->t_name+LINESIZE)) *p++ = c;
					}
				else break;
				}
			if (c == EOF || c == NEWLINE)
				error(0, "Non-terminated constant");
			if (c != '\'')
				error(0, "Bad hex constant");
			s->t_namep = p-(s->t_name);
			s->t_val = pack(s);
			return;

		case 'c':
		case 'C':
			s->t_state = CHAR;
			while ((c = nextchar())!=EOF && c!=NEWLINE && c!='\'') {
				if (c == BACKSLASH) switch(c = nextchar()) {
					case 'n':
						c = NEWLINE;
						break;
					case 't':
						c = TAB;
						break;
					case 'r':
						c = RETURN;
						break;
					case 'b':
						c = BACKSPACE;
						break;
					case '0':
						c = '\0';
						break;
					case 'q':
						c = '\'';
						break;
					}
				if (c != EOF) *p++ = c;
				}
			if (c == EOF || c == NEWLINE)
				error(0, "Non-terminated string");
			s->t_namep = p-(s->t_name);
			s->t_val = pack(s);
			return;
		default:
			error(0, "Syntax error");
		}
	}

/*
 * pack representation to object
 */

pack(tp)
TOKEN *tp;{

	register char *p, *q;
	register int extra;
	int n, c, x, y;
	int len;
	char pkbuf[LINESIZE];

	n = tp->t_namep;
	q = tp->t_name;
	p = pkbuf;
	extra = 0;
	len = tp->t_val;

	switch(tp->t_state) {
		case BIN:
			if ((extra = (len << 3)-n) < 0) extra = 0;
			x = (n+extra+7) >> 3;
			extra = x-((n+7) >> 3);
			while (extra--) *p++ = 0;
			*p = 0;
			p = pkbuf+x-1;
			c = 0;
			while (n--) {
				*p = (*p << 1) | ((*q++)-'0');
				if (c++ >= 7) {
					--p;
					c = 0;
					}
				}
			break;

		case HEX:
			if ((extra = (len << 1)-n) < 0) extra = 0;
			c = (n+extra+1) >> 1;
			extra = c-((n+1) >> 1);
			while (extra--) *p++ = 0;
			if (n & 1) {
				if ((x = *q++) >= '0' && x <= '9') x -= '0';
				else x -= ('a'-10);
				*p++ = x;
				--n;
				}
			for (; n > 0; n -= 2) {
				if ((x = *q++) >= '0' && x <= '9') x -= '0';
				else x -= ('a'-10);
				if ((y = *q++) >= '0' && y <= '9') y -= '0';
				else y -= ('a'-10);
				*p++ = (x << 4)+y;
				}
			x = c;
			break;

		case CHAR:
			if ((extra = len-n) < 0) extra = 0;
			move(q, p, n);
			p += n;
			x = n+extra;
			while (extra--) *p++ = ' ';
			break;
		}
	move(pkbuf, tp->t_name, LINESIZE);
	return(x);
	}
