/*
 * opcode types
 */
 
#define RR 1
#define RX 2
#define RS1 3
#define RS2 4
#define S 5
#define SI1 6
#define SI2 7
#define SS1 8
#define SS2 9
#define SS3 10
#define BRANCH 11
#define BRANCHR 12
 
/*
 * opcodes
 */
 
#define LOAD 0x58
#define ADD 0x5a
#define STORE 0x50
#define ADDH 0x4a
#define BALR 0x05
#define BC 0x47
#define BCR 0x07
#define SVC 0x0a
#define BAL 0x45
#define AD 0x6a          /* athletic director */
#define ADR 0x2a         /* Whitlow's turn this week */
#define AE 0x7a
#define AER 0x3a         /* atmospheric prefix */
#define AL 0x5e
#define ALR 0x1e
#define AP 0xfa          /* wire service */
#define AR 0x1a          /* auto-reject */
#define AU 0x7e
#define AUR 0x3e
#define AW 0x6e          /* root beer place */
#define AWR 0x2e
#define AXR 0x36
#define BCT 0x46
#define BCTR 0x06
#define BXH 0x86
#define BXLE 0x87
#define CMP 0x59
#define CD 0x69
#define CDR 0x29
#define CDS 0xbb         /* confuse data set */
#define CE 0x79          /* bridge builder */
#define CER 0x39
#define CH 0x49
#define CL 0x55
#define CLC 0xd5
#define CLCL 0x0f
#define CLI 0x95
#define CLRIO 0x9d01
#define CLM 0xbd
#define CLR 0x15
#define CP 0xf9
#define CR 0x19          /* carriage return */
#define CS 0xba          /* moron's major */
#define CVB 0x4f
#define CVD 0x4e
#define DIAG 0x83
#define DIV 0x5d
#define DD 0x6d
#define DDR 0x2d
#define DE 0x7d          /* The First State */
#define DER 0x3d         /* German pronoun */
#define DP 0xfd          /* COBOL business */
#define DR 0x1d          /* Post Office abbr. */
#define ED 0xde          /* A horse of a horse of course */
#define EDMK 0xdf
#define EX 0x44          /* former */
#define HDR 0x24
#define HDV 0x9e01
#define HER 0x34         /* no, him. */
#define HIO 0x9e00
#define IC 0x43          /* technological revolutionary */
#define ICM 0xbf         /* successor to IBM */
#define IPK 0xb20b
#define ISK 0x09
#define LA 0x41          /* a note to follow "so" */
#define LCR 0x13         /* predecessor of NCR */
#define LCDR 0x23
#define LCER 0x33
#define LCTL 0xb7
#define LD 0x68
#define LDR 0x28
#define LE 0x78          /* Spanish neuter */
#define LER 0x38         /* misspelled form of a stare */
#define LH 0x48
#define LM 0x98
#define LNDR 0x21
#define LNER 0x31
#define LNR 0x11
#define LPDR 0x20
#define LPER 0x30
#define LPR 0x10
#define LPSW 0x82
#define LR 0x18
#define LRA 0xb1
#define LRDR 0x25
#define LRER 0x35
#define LTDR 0x22
#define LTER 0x32        /* Go metric! */
#define LTR 0x12
#define MULT 0x5c
#define MC 0xaf
#define MD 0x6c          /* The rich and the super-rich */
#define MDR 0x2c
#define ME 0x7c          /* ego, superego & id */
#define MER 0x3c
#define MH 0x4c
#define MP 0xfc
#define MR 0x1c          /* complement of both MRS and MS */
#define MVC 0xd2
#define MVCL 0x0e
#define MVI 0x92
#define MVN 0xd1
#define MVO 0xf1
#define MVZ 0xd3
#define MXD 0x67         /* group with both sexes */
#define MXDR 0x27
#define MXR 0x26
#define AND 0x54
#define ANDC 0xd4
#define ANDR 0x14
#define ANDI 0x94
#define OR 0x56
#define OC 0xd6
#define OI 0x96
#define ORR 0x16         /* famous hockey player */
#define PACK 0xf2        /* pre-trip activity */
#define PTLB 0xb20d      /* coast guard craft */
#define RDD 0x85
#define RRB 0xb213
#define SUB 0x5b         /* Philadelphia hoagie */
#define SCK 0xb204
#define SCKC 0xb206
#define SUBD 0x6b
#define SDR 0x2b
#define SUBE 0x7b
#define SER 0x3b
#define SHop 0x4b
#define SIGP 0xae        /* core-dumping signal */
#define SIO 0x9c00
#define SIOF 0x9c01
#define SLop 0x5f
#define SLA 0x8b         /* Symbionese Liberation Army */
#define SLDA 0x8f
#define SLDL 0x8d
#define SLL 0x89
#define SLR 0x1f
#define SP 0xfb          /* stack pointer */
#define SPKA 0xb20a
#define SPM 0x04         /* Spam, spam, spam, ... */
#define SPT 0xb208
#define SPX 0xb210
#define SR 0x1b
#define SRA 0x8a         /* I never got past Aqua */
#define SRDA 0x8e
#define SRDL 0x8c
#define SRL 0x88
#define SRP 0xf0
#define SSK 0x08
#define SSM 0x80
#define STAP 0xb212
#define STC 0x42
#define STCK 0xb205
#define STCKC 0xb207
#define STCTL 0xb6
#define STCM 0xbe
#define STD 0x60
#define STE 0x70
#define STH 0x40
#define STIDC 0xb203
#define STIDP 0xb202
#define STM 0x90
#define STNSM 0xac       /* what a phaser can do, when at the proper setting */
#define STOSM 0xad
#define STPT 0xb209
#define STPX 0xb211
#define SU 0x7f          /* Super-user */
#define SUR 0x3f         /* big place in California */
#define SW 0x6f          /* switch */
#define SWR 0x2f
#define SXR 0x37
#define TCH 0x9f
#define TIO 0x9d         /* Spanish uncle */
#define TM 0x91          /* Transcendental Meditate */
#define TR 0xdc
#define TRT 0xdd
#define TS 0x93
#define UNPK 0xf3        /* post-trip activity */
#define WRD 0x84         /* a weird instruction */
#define XOR 0x57
#define XC 0xd7
#define XR 0x17
#define XI 0x97
#define ZAP 0xf8
 
/*
 * pseudo ops
 */
 
#define CSECT -3
#define DSECT -4
#define TEXT -5
#define DATA -6
#define BSS -7
#define WXTRN -9
#define EXTRN -10
#define ENTRY -11
#define DENTRY -8
#define DC -12
#define LTORG -15
#define ENDOP -16
#define USING -17
#define DROP -18
#define DS -19
/*      SYS -20  obsolete */
#define CNOP -21
#define COMM -22
#define CCW -23

/*
 * special for compiler/debugger
 */

#define CSYM -24
#define CLINENO -25
#define CBLOCK -26
#define CFUNC -27
#define CFILE -28
