#include <stdio.h>
#include "sym.h"
#include "assem.h"
#include "numlab.h"
#include "scanner.h"

/*
 * expression evaluator for assembler
 */

#define EMOV(e,a,b,c,d) {(e)->e_type=a;(e)->e_val=b;(e)->e_len=c;(e)->e_symp=d;}

expres(e)
register EXPR *e;{

	EXPR e1, e2;
	register int op, nextop;
	register TOKEN *tp;

	tp = &curtoke;
	EMOV(e,0,0,0,NULL)
	EMOV(&e1, 0, 0, 0, NULL)
	op = term(&e1);
	while (op == '+' || op == '-'){
		(*scan)(tp, 1);
		EMOV(&e2, 0, 0, 0, NULL)
		nextop = term(&e2);
		combin(&e1, &e2, op, e);
		EMOV(&e1, e->e_type, e->e_val, e->e_len, e->e_symp)
		op = nextop;
		}
	EMOV(e, e1.e_type, e1.e_val, e1.e_len, e1.e_symp)
	return(op);
	}

term(e)
register EXPR *e;{

	EXPR e1, e2;
	register int op, nextop;
	register TOKEN *tp;

	tp = &curtoke;
	EMOV(&e1, 0, 0, 0, NULL)
	op = factor(&e1);
	while (op == '*' || op == '/'){
		(*scan)(tp, 1);
		EMOV(&e2, 0, 0, 0, NULL)
		nextop = factor(&e2);
		combin(&e1, &e2, op, e);
		EMOV(&e1, e->e_type, e->e_val, e->e_len, e->e_symp)
		op = nextop;
		}
	EMOV(e, e1.e_type, e1.e_val, e1.e_len, e1.e_symp)
	return(op);
	}

factor(e)
register EXPR *e;{

	char cval[LINESIZE];
	EXPR e1;
	struct fb *num;
	register SYM *s;
	int n;
	register int nextop;
	char *p;
	register TOKEN *tp;

	tp = &curtoke;
	switch(tp->t_state) {
		case DIG:
			EMOV(e, ABSOLUTE, tp->t_val, BPW, NULL)
			(*scan)(tp, 1);
			if (tp->t_state == ID){
				p = (tp->t_sym)->s_name;
				if (*(p+1) != '\0') return(tp->t_state);
				nextop = *p;
				if (nextop == 'f')
					num = &nxtfb[e->e_val];
				else if (nextop == 'b')
					num = &curfb[e->e_val];
				else return(tp->t_state);
				if (scan == scan2 && num->fb_rel == UNDEFINED)
					error(0, "Numeric label not defined");
				EMOV(e, num->fb_rel, num->fb_addr, 0, (SYM *)num)
				(*scan)(tp, 1);
				}
			return(tp->t_state);
		case ABS:
			EMOV(e, ABSOLUTE, tp->t_val, BPW, NULL)
			break;
		case ID:
			s = tp->t_sym;
			if (scan == scan1){
				if ((s->s_type & LOCAL) == ABSOLUTE)
					EMOV(e,ABSOLUTE,s->s_val,s->s_len,NULL)
				else EMOV(e, s->s_type, 0, s->s_len, s)
				}
			else {
				if (s->s_type == UNDEFINED) {
					if (uflag) s->s_type |= EXTERN;
					else error(0, "%s undefined", s->s_name);
					}
				n = s->s_type & LOCAL;
				if (n > TEXTSEG && n < DABS){
					n = oseek[n-TEXTSEG]-oseek[0];
					EMOV(e,s->s_type,s->s_val+n,s->s_len,s)
					}
				else EMOV(e,s->s_type,s->s_val,s->s_len,s)
				}
			break;
		case ADOT:
			n = dot+oseek[dotrel-TEXTSEG]-oseek[0];
			EMOV(e, dotrel, n, BPW, NULL)
			break;
		case LQ:
			(*scan)(tp, 1);
			nextop = factor(&e1);
			EMOV(e, ABSOLUTE, e1.e_len, BPW, NULL)
			return(nextop);
		case '+':
			(*scan)(tp, 1);
			return(factor(e));
		case '-':
			(*scan)(tp, 1);
			nextop = factor(e);
			e->e_val = -(e->e_val);
			return(nextop);
		case '(':
			(*scan)(tp, 1);
			nextop = expres(e);
			if (nextop != ')')
				error(0, "Missing right parenthesis");
			break;
		case '=':
			(*scan)(tp, 1);
			if (scan == scan1){
				lit(e);
				EMOV(e, dotrel, 0, 0, NULL)
				}
			else {
				nextop = getw(litfil);
				e->e_type = dotrel;
				e->e_val = getw(litfil)+litcount[nextop];
				e->e_val += oseek[litrel-TEXTSEG]-oseek[0];
				dc2(&e1, cval);
				e->e_symp = e1.e_symp;
				}
			return(tp->t_state);
		case CHAR:
			if (tp->t_namep > 1) return(CHAR);
			EMOV(e, ABSOLUTE, tp->t_name[0], 1, NULL)
			break;
		case HEX:
		case BIN:
			e->e_len = tp->t_val;
			if (e->e_len > BPW) return(tp->t_state);
			e->e_type = ABSOLUTE;
			p = tp->t_name;
			e->e_val = *(int *)p >> ((BPW-e->e_len) << 3);
			break;
		default:
			return(tp->t_state);
		}
	(*scan)(tp, 1);
	return(tp->t_state);
	}

combin(e1, e2, op, e)
int op;
register EXPR *e1, *e2, *e;{

	int a1, a2, t1, t2;

	t1 = (e1->e_type) & LOCAL;
	t2 = (e2->e_type) & LOCAL;
	if (scan == scan1 && (t1 == UNDEFINED || t2 == UNDEFINED)){
		EMOV(e, UNDEFINED, 0, 0, NULL)
		return;
		}
	a1 = (t1 == ABSOLUTE);
	a2 = (t2 == ABSOLUTE);
	if (!a1 && !a2 && t1 != t2){
		error(-1, "Can't combine types");
		EMOV(e, ABSOLUTE, 0, 0, NULL)
		return;
		}
	if (!a1 && !a2 && op != '-'){
		error(-1, "Can't combine symbols");
		EMOV(e, ABSOLUTE, 0, 0, NULL)
		return;
		}
	if (!a1){
		move((char *)e1, (char *)e, sizeof(*e));
		}
	else if (!a2){
		move((char *)e2, (char *)e, sizeof(*e));
		}
	else {
		e->e_type = ABSOLUTE;
		e->e_len = BPW;
		e->e_symp = NULL;
		}
	switch(op) {
		case '+':
			e->e_val = e1->e_val+e2->e_val;
			break;
		case '-':
			if (!a1 && !a2){
				e->e_type = ABSOLUTE;
				if (scan == scan1){
					if (e1->e_symp != NULL)
						e1->e_val += e1->e_symp->s_val;
					if (e2->e_symp != NULL)
						e2->e_val += e2->e_symp->s_val;
					}
				}
			e->e_val = e1->e_val-e2->e_val;
			e->e_symp = NULL;
			break;
		case '*':
			e->e_val = e1->e_val*e2->e_val;
			break;
		case '/':
			e->e_val = e1->e_val/e2->e_val;
			break;
		default:
			error(0, "Shazbat!");
		}
	}
